#!/usr/bin/env python3
import argparse, os, sys, runpy, builtins, datetime as dt

def utc_timestamp():
    return dt.datetime.now(dt.timezone.utc).strftime("%Y-%m-%dT%H-%M-%SZ")

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--manifest", default="runs/2025-11-06T20-35-52Z/config/manifest_i24.json")
    ap.add_argument("--outdir", default=None)
    args = ap.parse_args()

    repo_root = os.path.dirname(__file__)
    engine_path = os.path.join(repo_root, "engine_i24_no_signalling.py")
    manifest = os.path.join(repo_root, args.manifest) if not os.path.isabs(args.manifest) else args.manifest

    if args.outdir:
        outdir = args.outdir if os.path.isabs(args.outdir) else os.path.join(repo_root, args.outdir)
    else:
        outdir = os.path.join(repo_root, "runs", utc_timestamp())
    os.makedirs(outdir, exist_ok=True)

    orig_any = builtins.any
    def patched_any(x):
        return x if isinstance(x, bool) else orig_any(x)
    builtins.any = patched_any
    try:
        old_argv = sys.argv[:]
        sys.argv = ["engine_i24_no_signalling.py", "--manifest", manifest, "--outdir", outdir]
        runpy.run_path(engine_path, run_name="__main__")
    finally:
        builtins.any = orig_any
        sys.argv = old_argv

    print("Re-run complete.")
    print("Manifest:", manifest)
    print("Outdir:  ", outdir)

if __name__ == "__main__":
    main()
